<?php

final class ITSEC_Malware_Logs {
	public function __construct() {
		add_filter( 'itsec_logs_prepare_malware_entry_for_list_display', array( $this, 'filter_entry_for_list_display' ) );
		add_filter( 'itsec_logs_prepare_malware_entry_for_details_display', array( $this, 'filter_entry_for_details_display' ), 10, 4 );

		if ( did_action( 'admin_enqueue_scripts' ) ) {
			$this->enqueue();
		} else {
			add_action( 'admin_enqueue_scripts', array( $this, 'enqueue' ) );
		}
	}

	public function filter_entry_for_list_display( $entry ) {
		$entry['module_display'] = esc_html__( 'Malware Scan', 'better-wp-security' );

		if ( 'scan' === $entry['code'] && 'process-start' === $entry['type'] ) {
			$entry['description'] = esc_html__( 'Scan Performance', 'better-wp-security' );
		} else if ( 'clean' === $entry['code'] ) {
			$entry['description'] = esc_html__( 'Clean', 'better-wp-security' );
		} else if ( 'scan-failure-server-error' === $entry['code'] ) {
			$entry['description'] = esc_html__( 'Scan Failed: Sucuri Error', 'better-wp-security' );
		} else if ( 'scan-failure-client-error' === $entry['code'] ) {
			$entry['description'] = esc_html__( 'Scan Failed: Site Error', 'better-wp-security' );
		} else if ( 'sucuri-system-error' === $entry['code'] ) {
			$entry['description'] = esc_html__( 'Scan Failed: Sucuri Error', 'better-wp-security' );
		} else if ( 'found-malware-and-on-blacklist' === $entry['code'] ) {
			$entry['description'] = esc_html__( 'Malware Found, Site on Blacklist', 'better-wp-security' );
		} else if ( 'found-malware' === $entry['code'] ) {
			$entry['description'] = esc_html__( 'Malware Found', 'better-wp-security' );
		} else if ( 'on-blacklist' === $entry['code'] ) {
			$entry['description'] = esc_html__( 'Site on Blacklist', 'better-wp-security' );
		} else if ( 'scan' === $entry['code'] ) {
			$entry['description'] = esc_html__( 'Scan', 'better-wp-security' );
		}

		return $entry;
	}

	public function filter_entry_for_details_display( $details, $entry, $code, $code_data ) {
		require_once( dirname( __FILE__ ) . '/class-itsec-malware-scan-results-template.php' );


		$entry = $this->filter_entry_for_list_display( $entry, $code, $code_data );

		$details['module']['content'] = $entry['module_display'];
		$details['description']['content'] = $entry['description'];

		if ( 'process-start' !== $entry['type'] ) {
			$details['results'] = array(
				'header'  => esc_html__( 'Results', 'better-wp-security' ),
				'content' => ITSEC_Malware_Scan_Results_Template::get_html( $entry['data']['results'], true ),
			);
		}

		return $details;
	}

	public function enqueue() {
		wp_enqueue_script( 'itsec-malware-scan-logs', plugin_dir_url( __FILE__ ) . 'js/malware.js', array( 'jquery' ), 3 );
	}
}
new ITSEC_Malware_Logs();
